﻿//Library Name: cvt_Privilege.OnLoad.js
//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.Privilege_OnLoad = {};

//Onload - Allow first time entry and name built
MCS.Privilege_OnLoad.OnLoad = function () {
    if (Xrm.Page.ui.getFormType() == 1) {
        Xrm.Page.getAttribute("cvt_name").setSubmitMode("always");
        //Check if fields are mapped, then it is Proxy; don't clear out Referenced TSS Priv
        if (Xrm.Page.getAttribute('cvt_referencedprivilegeid').getValue() != null) {
            Xrm.Page.getAttribute('cvt_typeofprivileging').setValue(917290001);
        }
        else {
            Xrm.Page.getAttribute('cvt_typeofprivileging').setValue(917290000);
        }
        Xrm.Page.getControl("cvt_typeofprivileging").setDisabled(true);
        Xrm.Page.getAttribute("cvt_typeofprivileging").setSubmitMode("always");

        Xrm.Page.getControl('statuscode').setDisabled(true);
        Xrm.Page.getAttribute("statuscode").setSubmitMode("always");
        Xrm.Page.getControl("cvt_servicetypeid").setDisabled(false);
    }
    else {
        MCS.Privilege_OnLoad.CheckUser();
        var statusReason = (Xrm.Page.getAttribute('statuscode').getValue() != null) ? Xrm.Page.getAttribute('statuscode').getSelectedOption().value : null;
        if (statusReason == 917290001) { //Privileged
            //Make entire form readonly.
            Xrm.Page.getControl("cvt_providerid").setDisabled(true);
            Xrm.Page.getControl("cvt_privilegedatid").setDisabled(true);
            Xrm.Page.getControl("cvt_typeofprivileging").setDisabled(true);
            Xrm.Page.getControl("cvt_servicetypeid").setDisabled(true);
            Xrm.Page.getControl("cvt_servicesubtypeid").setDisabled(true);
            Xrm.Page.getControl("ownerid").setDisabled(true);
            Xrm.Page.getControl("cvt_referencedprivilegeid").setDisabled(true);
        }
    }
};

//If User is disabled, display notification
MCS.Privilege_OnLoad.CheckUser = function () {
    if (Xrm.Page.getAttribute('cvt_providerid').getValue() != null)
        provLookup = Xrm.Page.getAttribute('cvt_providerid').getValue()[0].id;
    else
        return;

    var calls = CrmRestKit.Retrieve("SystemUser", provLookup, ['IsDisabled'], false);
    calls.done(function (data) {
        if (data && data.d) {
            if (data.d.IsDisabled == 1) {
                var notificationsList = Sys.Application.findComponent('crmNotifications');

                if (notificationsList) {
                    notificationsList.AddNotification('noteId1', 2, 'namespace', 'Provider record is currently deactivated.');
                }
            }
        }
    }).fail(
            function (error) {
            });
};